package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.modifiers.RequiresSkillRoll;
import com.hero.util.Constants;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class RequiresSkillRollDialog extends ModifierDialog {
	private static final long serialVersionUID = -7026641888304808733L;

	JComboBox rollCombo;

	JComboBox rollCombo2;

	JLabel rollLbl;

	JLabel rollLbl2;

	public RequiresSkillRollDialog(RequiresSkillRoll mod, boolean isNew,
			GenericObject parent) {
		super(mod, isNew, parent);
		mod.setSelectedOption(mod.getSelectedOption());
		if (!isNew) {
			ArrayList<GenericObject> chars = HeroDesigner.getActiveTemplate()
					.getCharacteristics();
			RequiresSkillRoll rsr = (RequiresSkillRoll) modifier;
			String roll1Alias = mod.getRollAlias();
			String roll2Alias = mod.getRoll2Alias();
			if (rsr.getType() == RequiresSkillRoll.skillType) {
				rollCombo.setSelectedIndex(0);
			} else if (rsr.getType() == RequiresSkillRoll.backgroundType) {
				rollCombo.setSelectedIndex(1);
			} else if (rsr.getType() == RequiresSkillRoll.perType) {
				rollCombo.setSelectedIndex(2);
			} else if (rsr.getType() == RequiresSkillRoll.charType) {
				for (int i = 0; i < chars.size(); i++) {
					Characteristic ch = (Characteristic) chars.get(i);
					if (ch.getType() == rsr.getCharacteristic()) {
						rollCombo.setSelectedIndex(i + 3);
					}
				}
			} else {
				rollCombo.setSelectedIndex(0);
			}
			((JTextField) rollCombo.getEditor().getEditorComponent())
					.setText(roll1Alias);
			if (rsr.getType2() == RequiresSkillRoll.skillType) {
				rollCombo2.setSelectedIndex(0);
			} else if (rsr.getType2() == RequiresSkillRoll.backgroundType) {
				rollCombo2.setSelectedIndex(1);
			} else if (rsr.getType2() == RequiresSkillRoll.perType) {
				rollCombo2.setSelectedIndex(2);
			} else if (rsr.getType2() == RequiresSkillRoll.charType) {
				for (int i = 0; i < chars.size(); i++) {
					Characteristic ch = (Characteristic) chars.get(i);
					if (ch.getType() == rsr.getCharacteristic()) {
						rollCombo2.setSelectedIndex(i + 3);
					}
				}
			} else {
				rollCombo2.setSelectedIndex(0);
			}
			((JTextField) rollCombo2.getEditor().getEditorComponent())
					.setText(roll2Alias);
		}
		updateValues();
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 47;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(5, 5, 5, 5);
		panel.add(rollLbl, gbc);
		gbc.gridy = 48;
		panel.add(rollLbl2, gbc);
		gbc.gridx = 1;
		gbc.gridy = 47;
		gbc.weightx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		panel.add(rollCombo, gbc);
		gbc.gridy = 48;
		panel.add(rollCombo2, gbc);
		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		rollCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (rollCombo.getSelectedItem() instanceof Characteristic) {
					Characteristic chara = (Characteristic) rollCombo
							.getSelectedItem();
					((RequiresSkillRoll) modifier)
							.setType(RequiresSkillRoll.charType);
					((RequiresSkillRoll) modifier).setCharacteristic(Constants
							.getCharacteristicInteger(chara.getXMLID()));
				} else if (rollCombo.getSelectedIndex() == 0) {
					((RequiresSkillRoll) modifier)
							.setType(RequiresSkillRoll.skillType);
				} else if (rollCombo.getSelectedIndex() == 1) {
					((RequiresSkillRoll) modifier)
							.setType(RequiresSkillRoll.backgroundType);
				} else if (rollCombo.getSelectedIndex() == 2) {
					((RequiresSkillRoll) modifier)
							.setType(RequiresSkillRoll.perType);
				}
				updateValues();
			}
		});
		rollCombo2.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (rollCombo2.getSelectedItem() instanceof Characteristic) {
					Characteristic chara = (Characteristic) rollCombo2
							.getSelectedItem();
					((RequiresSkillRoll) modifier)
							.setType2(RequiresSkillRoll.charType);
					((RequiresSkillRoll) modifier).setCharacteristic2(Constants
							.getCharacteristicInteger(chara.getXMLID()));
				} else if (rollCombo2.getSelectedIndex() == 0) {
					((RequiresSkillRoll) modifier)
							.setType2(RequiresSkillRoll.skillType);
				} else if (rollCombo2.getSelectedIndex() == 1) {
					((RequiresSkillRoll) modifier)
							.setType2(RequiresSkillRoll.backgroundType);
				} else if (rollCombo2.getSelectedIndex() == 2) {
					((RequiresSkillRoll) modifier)
							.setType2(RequiresSkillRoll.perType);
				}
				updateValues();
			}
		});
		((JTextField) rollCombo.getEditor().getEditorComponent()).getDocument()
				.addDocumentListener(new DocumentListener() {
					public void changedUpdate(DocumentEvent e) {
						String text = ((JTextField) rollCombo.getEditor()
								.getEditorComponent()).getText();
						if (text.trim().length() > 1) {
							((RequiresSkillRoll) modifier).setRollAlias(text);
							updateValues();
						}
					}

					public void insertUpdate(DocumentEvent e) {
						String text = ((JTextField) rollCombo.getEditor()
								.getEditorComponent()).getText();
						if (text.trim().length() > 1) {
							((RequiresSkillRoll) modifier).setRollAlias(text);
							updateValues();
						}
					}

					public void removeUpdate(DocumentEvent e) {
						String text = ((JTextField) rollCombo.getEditor()
								.getEditorComponent()).getText();
						if (text.trim().length() > 1) {
							((RequiresSkillRoll) modifier).setRollAlias(text);
							updateValues();
						}
					}
				});
		((JTextField) rollCombo2.getEditor().getEditorComponent())
				.getDocument().addDocumentListener(new DocumentListener() {
					public void changedUpdate(DocumentEvent e) {
						String text = ((JTextField) rollCombo2.getEditor()
								.getEditorComponent()).getText();
						if (text.trim().length() > 1) {
							((RequiresSkillRoll) modifier).setRoll2Alias(text);
							updateValues();
						}
					}

					public void insertUpdate(DocumentEvent e) {
						String text = ((JTextField) rollCombo2.getEditor()
								.getEditorComponent()).getText();
						if (text.trim().length() > 1) {
							((RequiresSkillRoll) modifier).setRoll2Alias(text);
							updateValues();
						}
					}

					public void removeUpdate(DocumentEvent e) {
						String text = ((JTextField) rollCombo2.getEditor()
								.getEditorComponent()).getText();
						if (text.trim().length() > 1) {
							((RequiresSkillRoll) modifier).setRoll2Alias(text);
							updateValues();
						}
					}
				});
		optionsCB.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (optionsCB.getSelectedItem() instanceof Adder) {
					Adder op = (Adder) optionsCB.getSelectedItem();
					if (op.getXMLID().equals("TWOROLLS")) {
						rollLbl2.setVisible(true);
						rollCombo2.setVisible(true);
						rollLbl.setVisible(true);
						rollCombo.setVisible(true);
					} else if (op.getXMLID().equals("BASICRSR")) {
						rollLbl2.setVisible(false);
						rollCombo2.setVisible(false);
						rollLbl.setVisible(true);
						rollCombo.setVisible(true);
					} else {
						rollLbl2.setVisible(false);
						rollCombo2.setVisible(false);
						rollLbl.setVisible(false);
						rollCombo.setVisible(false);
					}
					((RequiresSkillRoll) modifier)
							.setRefreshAddersOnUpdate(true);
				}
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		rollLbl = new JLabel("Roll:");
		rollLbl2 = new JLabel("2nd Roll:");
		optionsLbl.setText("Type:");
		ArrayList vec = new ArrayList();
		vec.add("Skill");
		vec.add("Background Skill");
		vec.add("PER");
		ArrayList<GenericObject> chars = HeroDesigner.getActiveTemplate()
				.getCharacteristics();
		for (int i = 0; i < chars.size(); i++) {
			vec.add(chars.get(i));
		}
		rollCombo = new JComboBox(vec.toArray());
		rollCombo.setEditable(true);
		rollCombo2 = new JComboBox(vec.toArray());
		rollCombo2.setEditable(true);
		if (((RequiresSkillRoll) modifier).getSelectedOption().getXMLID()
				.equals("TWOROLLS")) {
			rollLbl2.setVisible(true);
			rollCombo2.setVisible(true);
		} else {
			rollLbl2.setVisible(false);
			rollCombo2.setVisible(false);
		}
	}

	@Override
	public void updateValues() {
		super.updateValues();
	}

}